/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.apache.hc.core5.ssl.DummyProvider;
import org.apache.hc.core5.ssl.PrivateKeyStrategy;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestSSLContextBuilder {
    static final String PROVIDER_SUN_JSSE = "SunJSSE";
    static final String PROVIDER_SUN_JCE = "SunJCE";
    private static final Timeout TIMEOUT = Timeout.ofSeconds((long)5L);
    private ExecutorService executorService;

    TestSSLContextBuilder() {
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    @AfterEach
    void cleanup() throws Exception {
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
    }

    private URL getResource(String name) {
        return this.getClass().getResource(name);
    }

    @Test
    void testBuildAllDefaults() throws Exception {
        SSLContext sslContext = SSLContextBuilder.create().setKeyStoreType(KeyStore.getDefaultType()).setKeyManagerFactoryAlgorithm(KeyManagerFactory.getDefaultAlgorithm()).setTrustManagerFactoryAlgorithm(TrustManagerFactory.getDefaultAlgorithm()).setProvider(PROVIDER_SUN_JSSE).setProtocol("TLS").setSecureRandom(null).loadTrustMaterial((KeyStore)null, null).loadKeyMaterial((KeyStore)null, null, null).build();
        Assertions.assertNotNull((Object)sslContext);
        Assertions.assertEquals((Object)"TLS", (Object)sslContext.getProtocol());
        Assertions.assertEquals((Object)PROVIDER_SUN_JSSE, (Object)sslContext.getProvider().getName());
    }

    @Test
    void testBuildAllNull() throws Exception {
        SSLContext sslContext = SSLContextBuilder.create().setKeyStoreType(null).setKeyManagerFactoryAlgorithm(null).setTrustManagerFactoryAlgorithm(null).setProtocol(null).setProvider((String)null).setSecureRandom(null).loadTrustMaterial((KeyStore)null, null).loadKeyMaterial((KeyStore)null, null, null).build();
        Assertions.assertNotNull((Object)sslContext);
        Assertions.assertEquals((Object)"TLS", (Object)sslContext.getProtocol());
        Assertions.assertEquals((Object)PROVIDER_SUN_JSSE, (Object)sslContext.getProvider().getName());
    }

    @Test
    void testBuildAllNull_deprecated() throws Exception {
        SSLContext sslContext = SSLContextBuilder.create().setProtocol(null).setSecureRandom(null).loadTrustMaterial((KeyStore)null, null).loadKeyMaterial((KeyStore)null, null, null).build();
        Assertions.assertNotNull((Object)sslContext);
        Assertions.assertEquals((Object)"TLS", (Object)sslContext.getProtocol());
    }

    @Test
    void testBuildDefault() {
        Assertions.assertDoesNotThrow(() -> new SSLContextBuilder().build());
    }

    @Test
    void testBuildNoSuchKeyManagerFactoryAlgorithm() {
        URL resource1 = this.getResource("/test-keypasswd.p12");
        String storePassword = "nopassword";
        String keyPassword = "password";
        Assertions.assertThrows(NoSuchAlgorithmException.class, () -> SSLContextBuilder.create().setKeyManagerFactoryAlgorithm(" BAD ").loadKeyMaterial(resource1, "nopassword".toCharArray(), "password".toCharArray()).build());
    }

    @Test
    void testBuildNoSuchKeyStoreType() {
        URL resource1 = this.getResource("/test-keypasswd.p12");
        String storePassword = "nopassword";
        String keyPassword = "password";
        Assertions.assertThrows(KeyStoreException.class, () -> SSLContextBuilder.create().setKeyStoreType(" BAD ").loadKeyMaterial(resource1, "nopassword".toCharArray(), "password".toCharArray()).build());
    }

    @Test
    void testBuildNoSuchTrustManagerFactoryAlgorithm() {
        URL resource1 = this.getResource("/test-keypasswd.p12");
        String storePassword = "nopassword";
        Assertions.assertThrows(NoSuchAlgorithmException.class, () -> SSLContextBuilder.create().setTrustManagerFactoryAlgorithm(" BAD ").loadTrustMaterial(resource1, "nopassword".toCharArray()).build());
    }

    @Test
    void testBuildWithProvider() throws Exception {
        URL resource1 = this.getResource("/test-server.p12");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        DummyProvider provider = new DummyProvider();
        SSLContextBuilder.create().setProvider((Provider)provider).loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assertions.assertTrue((boolean)provider.hasBeenRequested("SSLContext"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testBuildWithProviderName() throws Exception {
        DummyProvider provider = new DummyProvider();
        Security.insertProviderAt(provider, 1);
        try {
            URL resource1 = this.getResource("/test-server.p12");
            String storePassword = "nopassword";
            String keyPassword = "nopassword";
            SSLContextBuilder.create().setProvider("FAKE").loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
            Assertions.assertTrue((boolean)provider.hasBeenRequested("SSLContext"));
        }
        finally {
            Security.removeProvider("FAKE");
        }
    }

    @Test
    void testBuildKSWithNoSuchProvider() {
        Assertions.assertThrows(NoSuchProviderException.class, () -> SSLContextBuilder.create().setKeyStoreProvider("no-such-provider").build());
    }

    @Test
    void testBuildKSWithProvider() throws Exception {
        URL resource1 = this.getResource("/test-server.p12");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        DummyProvider provider = new DummyProvider();
        SSLContextBuilder.create().setKeyStoreProvider((Provider)provider).loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assertions.assertTrue((boolean)provider.hasBeenRequested("KeyManagerFactory"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testBuildKSWithProviderName() throws Exception {
        DummyProvider provider = new DummyProvider();
        Security.insertProviderAt(provider, 1);
        try {
            URL resource1 = this.getResource("/test-server.p12");
            String storePassword = "nopassword";
            String keyPassword = "nopassword";
            SSLContextBuilder.create().setKeyStoreProvider("FAKE").loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
            Assertions.assertTrue((boolean)provider.hasBeenRequested("KeyManagerFactory"));
        }
        finally {
            Security.removeProvider("FAKE");
        }
    }

    @Test
    void testBuildTSWithNoSuchProvider() {
        Assertions.assertThrows(NoSuchProviderException.class, () -> SSLContextBuilder.create().setTrustStoreProvider("no-such-provider").build());
    }

    @Test
    void testBuildTSWithProvider() throws Exception {
        DummyProvider provider = new DummyProvider();
        SSLContextBuilder.create().setTrustStoreProvider((Provider)provider).loadTrustMaterial((KeyStore)null, null).build();
        Assertions.assertTrue((boolean)provider.hasBeenRequested("TrustManagerFactory"));
    }

    @Test
    void testBuildTSWithProviderName() throws Exception {
        DummyProvider provider = new DummyProvider();
        Security.insertProviderAt(provider, 1);
        try {
            SSLContextBuilder.create().setTrustStoreProvider("FAKE").loadTrustMaterial((KeyStore)null, null).build();
            Assertions.assertTrue((boolean)provider.hasBeenRequested("TrustManagerFactory"));
        }
        finally {
            Security.removeProvider("FAKE");
        }
    }

    @Test
    void testKeyWithAlternatePasswordInvalid() {
        URL resource1 = this.getResource("/test-keypasswd.p12");
        String storePassword = "nopassword";
        String keyPassword = "!password";
        Assertions.assertThrows(UnrecoverableKeyException.class, () -> SSLContextBuilder.create().loadKeyMaterial(resource1, "nopassword".toCharArray(), "!password".toCharArray()).loadTrustMaterial(resource1, "nopassword".toCharArray()).build());
    }

    @Test
    void testSSLHandshakeServerTrusted() throws Exception {
        URL resource1 = this.getResource("/test.p12");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assertions.assertNotNull((Object)serverSslContext);
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(resource1, "nopassword".toCharArray()).build();
        Assertions.assertNotNull((Object)clientSslContext);
        ServerSocket serverSocket = serverSslContext.getServerSocketFactory().createServerSocket();
        serverSocket.bind(new InetSocketAddress(0));
        this.executorService = Executors.newSingleThreadExecutor();
        Future<Boolean> future = this.executorService.submit(() -> {
            try (Socket socket = serverSocket.accept();){
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(new byte[]{72, 105});
                outputStream.flush();
            }
            return Boolean.TRUE;
        });
        int localPort = serverSocket.getLocalPort();
        try (Socket clientSocket = clientSslContext.getSocketFactory().createSocket();){
            clientSocket.connect(new InetSocketAddress("localhost", localPort), TIMEOUT.toMillisecondsIntBound());
            clientSocket.setSoTimeout(TIMEOUT.toMillisecondsIntBound());
            InputStream inputStream = clientSocket.getInputStream();
            Assertions.assertEquals((int)72, (int)inputStream.read());
            Assertions.assertEquals((int)105, (int)inputStream.read());
            Assertions.assertEquals((int)-1, (int)inputStream.read());
        }
        Boolean result = future.get(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)result);
    }

    @Test
    void testSSLHandshakeServerNotTrusted() throws Exception {
        URL resource1 = this.getResource("/test-server.p12");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assertions.assertNotNull((Object)serverSslContext);
        URL resource2 = this.getResource("/test.p12");
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(resource2, "nopassword".toCharArray()).build();
        Assertions.assertNotNull((Object)clientSslContext);
        ServerSocket serverSocket = serverSslContext.getServerSocketFactory().createServerSocket();
        serverSocket.bind(new InetSocketAddress(0));
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.submit(() -> {
            try (SSLSocket socket = (SSLSocket)serverSocket.accept();){
                socket.getSession();
            }
            return Boolean.FALSE;
        });
        int localPort = serverSocket.getLocalPort();
        try (SSLSocket clientSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket();){
            clientSocket.connect(new InetSocketAddress("localhost", localPort), TIMEOUT.toMillisecondsIntBound());
            clientSocket.setSoTimeout(TIMEOUT.toMillisecondsIntBound());
            Assertions.assertThrows(IOException.class, clientSocket::startHandshake);
        }
    }

    @Test
    void testSSLHandshakeServerCustomTrustStrategy() throws Exception {
        URL resource1 = this.getResource("/test-server.p12");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assertions.assertNotNull((Object)serverSslContext);
        AtomicReference certChainRef = new AtomicReference();
        TrustStrategy trustStrategy = (chain, authType) -> {
            certChainRef.set(chain);
            return true;
        };
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(trustStrategy).build();
        Assertions.assertNotNull((Object)clientSslContext);
        ServerSocket serverSocket = serverSslContext.getServerSocketFactory().createServerSocket();
        serverSocket.bind(new InetSocketAddress(0));
        this.executorService = Executors.newSingleThreadExecutor();
        Future<Boolean> future = this.executorService.submit(() -> {
            try (Socket socket = serverSocket.accept();){
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(new byte[]{72, 105});
                outputStream.flush();
            }
            return Boolean.TRUE;
        });
        int localPort = serverSocket.getLocalPort();
        try (SSLSocket clientSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket();){
            clientSocket.connect(new InetSocketAddress("localhost", localPort), TIMEOUT.toMillisecondsIntBound());
            clientSocket.setSoTimeout(TIMEOUT.toMillisecondsIntBound());
            InputStream inputStream = clientSocket.getInputStream();
            Assertions.assertEquals((int)72, (int)inputStream.read());
            Assertions.assertEquals((int)105, (int)inputStream.read());
            Assertions.assertEquals((int)-1, (int)inputStream.read());
        }
        Boolean result = future.get(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)result);
        X509Certificate[] certs = (X509Certificate[])certChainRef.get();
        Assertions.assertNotNull((Object)certs);
        Assertions.assertEquals((int)2, (int)certs.length);
        X509Certificate cert1 = certs[0];
        Principal subjectDN1 = cert1.getSubjectDN();
        Assertions.assertNotNull((Object)subjectDN1);
        Assertions.assertEquals((Object)"CN=Test Server, OU=HttpComponents Project, O=Apache Software Foundation", (Object)subjectDN1.getName());
        X509Certificate cert2 = certs[1];
        Principal subjectDN2 = cert2.getSubjectDN();
        Assertions.assertNotNull((Object)subjectDN2);
        Assertions.assertEquals((Object)"EMAILADDRESS=dev@hc.apache.org, CN=Test CA, OU=HttpComponents Project, O=Apache Software Foundation", (Object)subjectDN2.getName());
        Principal issuerDN = cert2.getIssuerDN();
        Assertions.assertNotNull((Object)issuerDN);
        Assertions.assertEquals((Object)"EMAILADDRESS=dev@hc.apache.org, CN=Test CA, OU=HttpComponents Project, O=Apache Software Foundation", (Object)issuerDN.getName());
    }

    @Test
    void testSSLHandshakeClientUnauthenticated() throws Exception {
        URL resource1 = this.getResource("/test-server.p12");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assertions.assertNotNull((Object)serverSslContext);
        URL resource2 = this.getResource("/test-client.p12");
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(resource2, "nopassword".toCharArray()).build();
        Assertions.assertNotNull((Object)clientSslContext);
        SSLServerSocket serverSocket = (SSLServerSocket)serverSslContext.getServerSocketFactory().createServerSocket();
        serverSocket.setWantClientAuth(true);
        serverSocket.bind(new InetSocketAddress(0));
        this.executorService = Executors.newSingleThreadExecutor();
        Future<Principal> future = this.executorService.submit(() -> {
            Principal clientPrincipal = null;
            try (SSLSocket socket = (SSLSocket)serverSocket.accept();){
                SSLSession session = socket.getSession();
                try {
                    clientPrincipal = session.getPeerPrincipal();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    // empty catch block
                }
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(new byte[]{72, 105});
                outputStream.flush();
            }
            return clientPrincipal;
        });
        int localPort = serverSocket.getLocalPort();
        try (SSLSocket clientSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket();){
            clientSocket.connect(new InetSocketAddress("localhost", localPort), TIMEOUT.toMillisecondsIntBound());
            clientSocket.setSoTimeout(TIMEOUT.toMillisecondsIntBound());
            clientSocket.startHandshake();
            InputStream inputStream = clientSocket.getInputStream();
            Assertions.assertEquals((int)72, (int)inputStream.read());
            Assertions.assertEquals((int)105, (int)inputStream.read());
            Assertions.assertEquals((int)-1, (int)inputStream.read());
        }
        Principal clientPrincipal = future.get(5L, TimeUnit.SECONDS);
        Assertions.assertNull((Object)clientPrincipal);
    }

    @Test
    void testSSLHandshakeClientUnauthenticatedError() throws Exception {
        URL resource1 = this.getResource("/test-server.p12");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assertions.assertNotNull((Object)serverSslContext);
        URL resource2 = this.getResource("/test-client.p12");
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(resource2, "nopassword".toCharArray()).build();
        Assertions.assertNotNull((Object)clientSslContext);
        SSLServerSocket serverSocket = (SSLServerSocket)serverSslContext.getServerSocketFactory().createServerSocket();
        serverSocket.setNeedClientAuth(true);
        serverSocket.bind(new InetSocketAddress(0));
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.submit(() -> {
            try (SSLSocket socket = (SSLSocket)serverSocket.accept();){
                socket.getSession();
            }
            return Boolean.FALSE;
        });
        int localPort = serverSocket.getLocalPort();
        try (SSLSocket clientSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket();){
            clientSocket.connect(new InetSocketAddress("localhost", localPort), TIMEOUT.toMillisecondsIntBound());
            clientSocket.setSoTimeout(TIMEOUT.toMillisecondsIntBound());
            Assertions.assertThrows(IOException.class, () -> {
                clientSocket.startHandshake();
                InputStream inputStream = clientSocket.getInputStream();
                inputStream.read();
            });
        }
    }

    @Test
    void testSSLHandshakeClientAuthenticated() throws Exception {
        URL resource1 = this.getResource("/test-server.p12");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadTrustMaterial(resource1, "nopassword".toCharArray()).loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assertions.assertNotNull((Object)serverSslContext);
        URL resource2 = this.getResource("/test-client.p12");
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(resource2, "nopassword".toCharArray()).loadKeyMaterial(resource2, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assertions.assertNotNull((Object)clientSslContext);
        SSLServerSocket serverSocket = (SSLServerSocket)serverSslContext.getServerSocketFactory().createServerSocket();
        serverSocket.setNeedClientAuth(true);
        serverSocket.bind(new InetSocketAddress(0));
        this.executorService = Executors.newSingleThreadExecutor();
        Future<Principal> future = this.executorService.submit(() -> {
            try (SSLSocket socket = (SSLSocket)serverSocket.accept();){
                SSLSession session = socket.getSession();
                Principal clientPrincipal = session.getPeerPrincipal();
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(new byte[]{72, 105});
                outputStream.flush();
                Principal principal = clientPrincipal;
                return principal;
            }
        });
        int localPort = serverSocket.getLocalPort();
        try (SSLSocket clientSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket();){
            clientSocket.connect(new InetSocketAddress("localhost", localPort), TIMEOUT.toMillisecondsIntBound());
            clientSocket.setSoTimeout(TIMEOUT.toMillisecondsIntBound());
            clientSocket.startHandshake();
            InputStream inputStream = clientSocket.getInputStream();
            Assertions.assertEquals((int)72, (int)inputStream.read());
            Assertions.assertEquals((int)105, (int)inputStream.read());
            Assertions.assertEquals((int)-1, (int)inputStream.read());
        }
        Principal clientPrincipal = future.get(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)clientPrincipal);
    }

    @Test
    void testSSLHandshakeClientAuthenticatedPrivateKeyStrategy() throws Exception {
        URL resource1 = this.getResource("/test-server.p12");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadTrustMaterial(resource1, "nopassword".toCharArray()).loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assertions.assertNotNull((Object)serverSslContext);
        PrivateKeyStrategy privateKeyStrategy = (aliases, sslParameters) -> aliases.containsKey("client2") ? "client2" : null;
        URL resource2 = this.getResource("/test-client.p12");
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(resource2, "nopassword".toCharArray()).loadKeyMaterial(resource2, "nopassword".toCharArray(), "nopassword".toCharArray(), privateKeyStrategy).build();
        Assertions.assertNotNull((Object)clientSslContext);
        SSLServerSocket serverSocket = (SSLServerSocket)serverSslContext.getServerSocketFactory().createServerSocket();
        serverSocket.setNeedClientAuth(true);
        serverSocket.bind(new InetSocketAddress(0));
        this.executorService = Executors.newSingleThreadExecutor();
        Future<Principal> future = this.executorService.submit(() -> {
            try (SSLSocket socket = (SSLSocket)serverSocket.accept();){
                SSLSession session = socket.getSession();
                Principal clientPrincipal = session.getPeerPrincipal();
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(new byte[]{72, 105});
                outputStream.flush();
                Principal principal = clientPrincipal;
                return principal;
            }
        });
        int localPort = serverSocket.getLocalPort();
        try (SSLSocket clientSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket();){
            clientSocket.connect(new InetSocketAddress("localhost", localPort), TIMEOUT.toMillisecondsIntBound());
            clientSocket.setSoTimeout(TIMEOUT.toMillisecondsIntBound());
            clientSocket.startHandshake();
            InputStream inputStream = clientSocket.getInputStream();
            Assertions.assertEquals((int)72, (int)inputStream.read());
            Assertions.assertEquals((int)105, (int)inputStream.read());
            Assertions.assertEquals((int)-1, (int)inputStream.read());
        }
        Principal clientPrincipal = future.get(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)clientPrincipal);
        Assertions.assertEquals((Object)"CN=Test Client 2,OU=HttpComponents Project,O=Apache Software Foundation", (Object)clientPrincipal.getName());
    }

    @Test
    void testSSLHandshakeProtocolMismatch1() throws Exception {
        URL resource1 = this.getResource("/test-server.p12");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assertions.assertNotNull((Object)serverSslContext);
        URL resource2 = this.getResource("/test-client.p12");
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(resource2, "nopassword".toCharArray()).build();
        Assertions.assertNotNull((Object)clientSslContext);
        SSLServerSocket serverSocket = (SSLServerSocket)serverSslContext.getServerSocketFactory().createServerSocket();
        LinkedHashSet<String> supportedServerProtocols = new LinkedHashSet<String>(Arrays.asList(serverSocket.getSupportedProtocols()));
        Assertions.assertTrue((boolean)supportedServerProtocols.contains("TLSv1"));
        serverSocket.setEnabledProtocols(new String[]{"TLSv1"});
        serverSocket.bind(new InetSocketAddress(0));
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.submit(() -> {
            try (SSLSocket socket = (SSLSocket)serverSocket.accept();){
                socket.getSession();
            }
            return Boolean.FALSE;
        });
        int localPort = serverSocket.getLocalPort();
        try (SSLSocket clientSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket();){
            LinkedHashSet<String> supportedClientProtocols = new LinkedHashSet<String>(Arrays.asList(clientSocket.getSupportedProtocols()));
            Assertions.assertTrue((boolean)supportedClientProtocols.contains("SSLv3"));
            clientSocket.setEnabledProtocols(new String[]{"SSLv3"});
            clientSocket.connect(new InetSocketAddress("localhost", localPort), TIMEOUT.toMillisecondsIntBound());
            clientSocket.setSoTimeout(TIMEOUT.toMillisecondsIntBound());
            if (TestSSLContextBuilder.isWindows()) {
                Assertions.assertThrows(IOException.class, clientSocket::startHandshake);
            } else {
                Assertions.assertThrows(SSLException.class, clientSocket::startHandshake);
            }
        }
    }

    @Test
    void testSSLHandshakeProtocolMismatch2() throws Exception {
        URL resource1 = this.getResource("/test-server.p12");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assertions.assertNotNull((Object)serverSslContext);
        URL resource2 = this.getResource("/test-client.p12");
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(resource2, "nopassword".toCharArray()).build();
        Assertions.assertNotNull((Object)clientSslContext);
        SSLServerSocket serverSocket = (SSLServerSocket)serverSslContext.getServerSocketFactory().createServerSocket();
        LinkedHashSet<String> supportedServerProtocols = new LinkedHashSet<String>(Arrays.asList(serverSocket.getSupportedProtocols()));
        Assertions.assertTrue((boolean)supportedServerProtocols.contains("SSLv3"));
        serverSocket.setEnabledProtocols(new String[]{"SSLv3"});
        serverSocket.bind(new InetSocketAddress(0));
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.submit(() -> {
            try (SSLSocket socket = (SSLSocket)serverSocket.accept();){
                socket.getSession();
            }
            return Boolean.FALSE;
        });
        int localPort = serverSocket.getLocalPort();
        try (SSLSocket clientSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket();){
            LinkedHashSet<String> supportedClientProtocols = new LinkedHashSet<String>(Arrays.asList(clientSocket.getSupportedProtocols()));
            Assertions.assertTrue((boolean)supportedClientProtocols.contains("TLSv1"));
            clientSocket.setEnabledProtocols(new String[]{"TLSv1"});
            clientSocket.connect(new InetSocketAddress("localhost", localPort), TIMEOUT.toMillisecondsIntBound());
            clientSocket.setSoTimeout(TIMEOUT.toMillisecondsIntBound());
            if (TestSSLContextBuilder.isWindows()) {
                Assertions.assertThrows(IOException.class, clientSocket::startHandshake);
            } else {
                Assertions.assertThrows(SSLException.class, clientSocket::startHandshake);
            }
        }
    }

    @Test
    void testJSSEEndpointIdentification() throws Exception {
        URL resource1 = this.getResource("/test-server.p12");
        String storePassword = "nopassword";
        String keyPassword = "nopassword";
        SSLContext serverSslContext = SSLContextBuilder.create().loadKeyMaterial(resource1, "nopassword".toCharArray(), "nopassword".toCharArray()).build();
        Assertions.assertNotNull((Object)serverSslContext);
        URL resource2 = this.getResource("/test-client.p12");
        SSLContext clientSslContext = SSLContextBuilder.create().loadTrustMaterial(resource2, "nopassword".toCharArray()).build();
        Assertions.assertNotNull((Object)clientSslContext);
        SSLServerSocket serverSocket = (SSLServerSocket)serverSslContext.getServerSocketFactory().createServerSocket();
        serverSocket.bind(new InetSocketAddress(0));
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorService.submit(() -> {
            try {
                while (true) {
                    SSLSocket socket;
                    block12: {
                        socket = (SSLSocket)serverSocket.accept();
                        Throwable throwable = null;
                        try {
                            socket.getSession();
                            socket.shutdownOutput();
                            if (socket == null) continue;
                            if (throwable == null) break block12;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (socket == null) throw throwable3;
                                if (throwable == null) {
                                    socket.close();
                                    throw throwable3;
                                }
                                try {
                                    socket.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    socket.close();
                }
            }
            catch (IOException ex) {
                return Boolean.FALSE;
            }
        });
        int localPort1 = serverSocket.getLocalPort();
        try (Socket clientSocket = new Socket();){
            clientSocket.connect(new InetSocketAddress("localhost", localPort1));
            try (SSLSocket sslSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket(clientSocket, "localhost", -1, true);){
                SSLParameters sslParameters = sslSocket.getSSLParameters();
                sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
                sslSocket.setSSLParameters(sslParameters);
                sslSocket.startHandshake();
            }
        }
        int localPort2 = serverSocket.getLocalPort();
        try (Socket clientSocket = new Socket();){
            clientSocket.connect(new InetSocketAddress("localhost", localPort2));
            try (SSLSocket sslSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket(clientSocket, "otherhost", -1, true);){
                SSLParameters sslParameters = sslSocket.getSSLParameters();
                sslParameters.setEndpointIdentificationAlgorithm(null);
                sslSocket.setSSLParameters(sslParameters);
                sslSocket.startHandshake();
            }
        }
        int localPort3 = serverSocket.getLocalPort();
        Assertions.assertThrows(SSLException.class, () -> {
            try (Socket clientSocket = new Socket();){
                clientSocket.connect(new InetSocketAddress("localhost", localPort3));
                try (SSLSocket sslSocket = (SSLSocket)clientSslContext.getSocketFactory().createSocket(clientSocket, "otherhost", -1, true);){
                    SSLParameters sslParameters = sslSocket.getSSLParameters();
                    sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
                    sslSocket.setSSLParameters(sslParameters);
                    sslSocket.startHandshake();
                }
            }
        });
    }
}

