/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.factory.GeodeticObjectFactory;
import org.apache.sis.referencing.factory.InvalidGeodeticParameterException;
import org.apache.sis.referencing.internal.MergedProperties;
import org.apache.sis.referencing.internal.ParameterizedTransformBuilder;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.CoordinateOperations;
import org.apache.sis.referencing.operation.AbstractSingleOperation;
import org.apache.sis.referencing.operation.CRSPair;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.CoordinateOperationFinder;
import org.apache.sis.referencing.operation.DefaultConcatenatedOperation;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.DefaultProjection;
import org.apache.sis.referencing.operation.DefaultTransformation;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

public class DefaultCoordinateOperationFactory
extends AbstractFactory
implements CoordinateOperationFactory {
    static final boolean USE_EPSG_FACTORY = true;
    private final Map<String, ?> defaultProperties;
    final CRSFactory crsFactory;
    final CSFactory csFactory;
    private final MathTransformFactory mtFactory;
    private final WeakHashSet<IdentifiedObject> pool;
    final Cache<CRSPair, CoordinateOperation> cache;
    private static final DefaultCoordinateOperationFactory INSTANCE = new DefaultCoordinateOperationFactory();

    public static DefaultCoordinateOperationFactory provider() {
        return INSTANCE;
    }

    public DefaultCoordinateOperationFactory() {
        this(null, null);
    }

    public DefaultCoordinateOperationFactory(Map<String, ?> properties, MathTransformFactory factory) {
        GeodeticObjectFactory csFactory;
        GeodeticObjectFactory crsFactory;
        if (properties == null || properties.isEmpty()) {
            properties = Map.of();
            crsFactory = null;
            csFactory = null;
        } else {
            MathTransformFactory mtFactory;
            String key = null;
            Object value = null;
            properties = new HashMap(properties);
            try {
                key = "crsFactory";
                value = properties.remove("crsFactory");
                crsFactory = (CRSFactory)value;
                key = "csFactory";
                value = properties.remove("csFactory");
                csFactory = (CSFactory)value;
                key = "mtFactory";
                value = properties.remove("mtFactory");
                mtFactory = (MathTransformFactory)value;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(Errors.forProperties(properties).getString((short)73, (Object)key, (Object)Classes.getClass((Object)value)));
            }
            properties.remove("datumFactory");
            properties = Map.copyOf(properties);
            if (factory == null) {
                factory = mtFactory;
            }
        }
        this.mtFactory = factory != null ? factory : DefaultMathTransformFactory.provider();
        this.csFactory = csFactory != null ? csFactory : GeodeticObjectFactory.provider();
        this.crsFactory = crsFactory != null ? crsFactory : GeodeticObjectFactory.provider();
        this.defaultProperties = properties;
        this.pool = new WeakHashSet(IdentifiedObject.class);
        this.cache = new Cache(12, 50L, true);
    }

    protected Map<String, ?> complete(Map<String, ?> properties) {
        ArgumentChecks.ensureNonNull((String)"properties", properties);
        return new MergedProperties(properties, this.defaultProperties);
    }

    public final MathTransformFactory getMathTransformFactory() {
        return this.mtFactory;
    }

    @Deprecated(since="1.5", forRemoval=true)
    public OperationMethod getOperationMethod(String name) throws FactoryException {
        return CoordinateOperations.findMethod(this.mtFactory, name);
    }

    public OperationMethod createOperationMethod(Map<String, ?> properties, ParameterDescriptorGroup parameters) throws FactoryException {
        DefaultOperationMethod method;
        try {
            method = new DefaultOperationMethod(properties, parameters);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception.getLocalizedMessage(), exception);
        }
        return (OperationMethod)this.pool.unique((Object)method);
    }

    public Conversion createDefiningConversion(Map<String, ?> properties, OperationMethod method, ParameterValueGroup parameters) throws FactoryException {
        DefaultConversion conversion;
        try {
            conversion = new DefaultConversion(properties, method, null, parameters);
        }
        catch (IllegalArgumentException exception) {
            throw new InvalidGeodeticParameterException(exception.getLocalizedMessage(), exception);
        }
        return conversion;
    }

    private static boolean isConversion(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        ArrayDeque<SingleCRS> components = new ArrayDeque<SingleCRS>(CRS.getSingleComponents(sourceCRS));
        block0: for (SingleCRS component : CRS.getSingleComponents(targetCRS)) {
            Iterator<SingleCRS> it = components.iterator();
            while (it.hasNext()) {
                if (!DatumOrEnsemble.ofTarget(component, it.next()).isPresent()) continue;
                it.remove();
                continue block0;
            }
            return false;
        }
        return true;
    }

    public SingleOperation createSingleOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateReferenceSystem interpolationCRS, OperationMethod method, MathTransform transform) throws FactoryException {
        AbstractSingleOperation op;
        Class<? extends SingleOperation> c;
        Class baseType;
        ArgumentChecks.ensureNonNull((String)"sourceCRS", (Object)sourceCRS);
        ArgumentChecks.ensureNonNull((String)"targetCRS", (Object)targetCRS);
        ArgumentChecks.ensureNonNull((String)"method", (Object)method);
        if (transform == null) {
            ParameterValueGroup parameters = (ParameterValueGroup)Containers.property(properties, (Object)"parameters", ParameterValueGroup.class);
            if (parameters == null) {
                throw new NullPointerException(Errors.format((short)141, (Object)"transform"));
            }
            ParameterizedTransformBuilder builder = new ParameterizedTransformBuilder(this.getMathTransformFactory(), null);
            builder.setParameters(parameters, false);
            builder.setSourceAxes(sourceCRS);
            builder.setTargetAxes(targetCRS);
            transform = builder.create();
        }
        if ((baseType = (Class)Containers.property(properties, (Object)"operationType", Class.class)) == null) {
            baseType = SingleOperation.class;
        }
        if (method instanceof DefaultOperationMethod && (c = ((DefaultOperationMethod)method).getOperationType()) != null) {
            if (baseType.isAssignableFrom(c)) {
                baseType = c;
            } else if (!c.isAssignableFrom(baseType)) {
                throw new IllegalArgumentException(Errors.format((short)81, (Object)"operationType"));
            }
        }
        if (baseType == SingleOperation.class) {
            baseType = DefaultCoordinateOperationFactory.isConversion(sourceCRS, targetCRS) ? (interpolationCRS == null && sourceCRS instanceof GeographicCRS && targetCRS instanceof ProjectedCRS ? Projection.class : Conversion.class) : Transformation.class;
        }
        if (Transformation.class.isAssignableFrom(baseType)) {
            op = new DefaultTransformation(properties, sourceCRS, targetCRS, interpolationCRS, method, transform);
        } else if (Projection.class.isAssignableFrom(baseType)) {
            ArgumentChecks.ensureCanCast((String)"sourceCRS", GeographicCRS.class, (Object)sourceCRS);
            ArgumentChecks.ensureCanCast((String)"targetCRS", ProjectedCRS.class, (Object)targetCRS);
            if (interpolationCRS != null) {
                throw new IllegalArgumentException(Errors.format((short)53, (Object)"interpolationCRS", baseType));
            }
            op = new DefaultProjection(properties, (GeographicCRS)sourceCRS, (ProjectedCRS)targetCRS, method, transform);
        } else {
            op = Conversion.class.isAssignableFrom(baseType) ? new DefaultConversion(properties, sourceCRS, targetCRS, interpolationCRS, method, transform) : new AbstractSingleOperation(properties, sourceCRS, targetCRS, interpolationCRS, method, transform);
        }
        if (!baseType.isInstance(op)) {
            throw new FactoryException(Resources.format((short)4, baseType, op.getName()));
        }
        return (SingleOperation)this.pool.unique((Object)op);
    }

    @Deprecated(since="1.5", forRemoval=true)
    public CoordinateOperation createConcatenatedOperation(Map<String, ?> properties, CoordinateOperation ... operations) throws FactoryException {
        return this.createConcatenatedOperation(properties, (CoordinateReferenceSystem)null, (CoordinateReferenceSystem)null, operations);
    }

    public CoordinateOperation createConcatenatedOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateOperation ... operations) throws FactoryException {
        if (operations.length == 1 && sourceCRS == null && targetCRS == null) {
            return operations[0];
        }
        DefaultConcatenatedOperation op = new DefaultConcatenatedOperation(properties, sourceCRS, targetCRS, operations, this.getMathTransformFactory());
        List<SingleOperation> co = op.getOperations();
        if (co.size() != 1) {
            return (CoordinateOperation)this.pool.unique((Object)op);
        }
        CoordinateOperation single = (CoordinateOperation)co.get(0);
        if (Objects.equals(single.getSourceCRS(), op.getSourceCRS()) && Objects.equals(single.getTargetCRS(), op.getTargetCRS())) {
            assert (single.getMathTransform().equals((Object)op.getMathTransform())) : op;
        } else if (single instanceof SingleOperation) {
            HashMap merge = new HashMap(IdentifiedObjects.getProperties((IdentifiedObject)single, "identifiers"));
            merge.put("parameters", ((SingleOperation)single).getParameterValues());
            if (single instanceof AbstractIdentifiedObject) {
                merge.put("operationType", ((AbstractIdentifiedObject)single).getInterface());
            }
            merge.putAll(properties);
            return this.createSingleOperation(merge, op.getSourceCRS(), op.getTargetCRS(), op.getInterpolationCRS().orElse(null), ((SingleOperation)single).getMethod(), op.getMathTransform());
        }
        return single;
    }

    @Deprecated(since="1.5")
    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws OperationNotFoundException, FactoryException {
        return this.createOperation(sourceCRS, targetCRS, (CoordinateOperationContext)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateOperationContext context) throws OperationNotFoundException, FactoryException {
        Cache.Handler handler;
        CoordinateOperation op;
        if (context == null) {
            CRSPair key = new CRSPair(sourceCRS, targetCRS);
            op = (CoordinateOperation)this.cache.peek((Object)key);
            if (op != null) {
                return op;
            }
            handler = this.cache.lock((Object)key);
        } else {
            handler = null;
            op = null;
        }
        boolean canStoreInCache = true;
        try {
            if (handler == null || (op = (CoordinateOperation)handler.peek()) == null) {
                CoordinateOperationFinder finder = this.createOperationFinder(DefaultCoordinateOperationFactory.getFactorySIS(), context);
                op = finder.createOperation(sourceCRS, targetCRS);
                canStoreInCache = finder.canStoreInCache();
            }
            if (handler != null) {
                handler.putAndUnlock(canStoreInCache ? op : null);
            }
        }
        catch (Throwable throwable) {
            if (handler != null) {
                handler.putAndUnlock(canStoreInCache ? op : null);
            }
            throw throwable;
        }
        return op;
    }

    public List<CoordinateOperation> createOperations(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, CoordinateOperationContext context) throws OperationNotFoundException, FactoryException {
        return this.createOperationFinder(DefaultCoordinateOperationFactory.getFactorySIS(), context).createOperations(sourceCRS, targetCRS);
    }

    private static CoordinateOperationAuthorityFactory getFactorySIS() throws FactoryException {
        CRSAuthorityFactory registry = CRS.getAuthorityFactory("EPSG");
        if (registry instanceof CoordinateOperationAuthorityFactory) {
            return (CoordinateOperationAuthorityFactory)registry;
        }
        return null;
    }

    protected CoordinateOperationFinder createOperationFinder(CoordinateOperationAuthorityFactory registry, CoordinateOperationContext context) throws FactoryException {
        return new CoordinateOperationFinder(registry, this, context);
    }

    @Deprecated(since="0.7")
    public CoordinateOperation createOperation(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, OperationMethod method) throws FactoryException {
        ArgumentChecks.ensureNonNull((String)"method", (Object)method);
        return this.createOperation(sourceCRS, targetCRS, (CoordinateOperationContext)null);
    }
}

