/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal.util;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.sling.commons.log.logback.internal.util.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class XmlUtil {
    private XmlUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String prettyPrint(@NotNull InputSource is) {
        block10: {
            try {
                String string;
                StringWriter strWriter = new StringWriter();
                try {
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                    Transformer transformer = transformerFactory.newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                    StreamResult result = new StreamResult(strWriter);
                    SAXSource source = new SAXSource(is);
                    transformer.transform(source, result);
                    string = strWriter.toString();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            strWriter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LoggerFactory.getLogger(XmlUtil.class).warn("Error occurred while transforming xml", e);
                        break block10;
                    }
                }
                strWriter.close();
                return string;
            }
            finally {
                Util.close(is);
            }
        }
        return "Source not found";
    }

    @Nullable
    public static String escapeXml(@Nullable String input) {
        if (input == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '&') {
                b.append("&amp;");
                continue;
            }
            if (c == '<') {
                b.append("&lt;");
                continue;
            }
            if (c == '>') {
                b.append("&gt;");
                continue;
            }
            if (c == '\"') {
                b.append("&quot;");
                continue;
            }
            if (c == '\'') {
                b.append("&apos;");
                continue;
            }
            b.append(c);
        }
        return b.toString().replace("$", "&#37;");
    }
}

