/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.helper;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.sling.engine.impl.SlingHttpServletRequestImpl;
import org.apache.sling.engine.impl.SlingHttpServletResponseImpl;

class ExternalServletContextWrapper
implements ServletContext {
    private final ServletContext delegate;

    public ExternalServletContextWrapper(ServletContext sc) {
        this.delegate = sc;
    }

    protected final ServletContext getServletContext() {
        return this.delegate;
    }

    public ServletContext getContext(String s) {
        return this.getServletContext().getContext(s);
    }

    public int getMajorVersion() {
        return this.getServletContext().getMajorVersion();
    }

    public int getMinorVersion() {
        return this.getServletContext().getMinorVersion();
    }

    public String getMimeType(String s) {
        return this.getServletContext().getMimeType(s);
    }

    public Set<String> getResourcePaths(String s) {
        return this.getServletContext().getResourcePaths(s);
    }

    public URL getResource(String s) throws MalformedURLException {
        return this.getServletContext().getResource(s);
    }

    public InputStream getResourceAsStream(String s) {
        return this.getServletContext().getResourceAsStream(s);
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return new RequestDispatcherWrapper(this.getServletContext().getRequestDispatcher(s));
    }

    public RequestDispatcher getNamedDispatcher(String s) {
        return new RequestDispatcherWrapper(this.getServletContext().getNamedDispatcher(s));
    }

    @Deprecated
    public Servlet getServlet(String s) throws ServletException {
        return this.getServletContext().getServlet(s);
    }

    @Deprecated
    public Enumeration<Servlet> getServlets() {
        return this.getServletContext().getServlets();
    }

    @Deprecated
    public Enumeration<String> getServletNames() {
        return this.getServletContext().getServletNames();
    }

    public void log(String s) {
        this.getServletContext().log(s);
    }

    @Deprecated
    public void log(Exception exception, String s) {
        this.getServletContext().log(exception, s);
    }

    public void log(String s, Throwable throwable) {
        this.getServletContext().log(s, throwable);
    }

    public String getRealPath(String s) {
        return this.getServletContext().getRealPath(s);
    }

    public String getServerInfo() {
        return this.getServletContext().getServerInfo();
    }

    public String getInitParameter(String s) {
        return this.getServletContext().getInitParameter(s);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.getServletContext().getInitParameterNames();
    }

    public Object getAttribute(String s) {
        return this.getServletContext().getAttribute(s);
    }

    public Enumeration<String> getAttributeNames() {
        return this.getServletContext().getAttributeNames();
    }

    public void setAttribute(String s, Object obj) {
        this.getServletContext().setAttribute(s, obj);
    }

    public void removeAttribute(String s) {
        this.getServletContext().removeAttribute(s);
    }

    public String getServletContextName() {
        return this.getServletContext().getServletContextName();
    }

    public String getContextPath() {
        return this.getServletContext().getContextPath();
    }

    public int getEffectiveMajorVersion() {
        return this.getServletContext().getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.getServletContext().getEffectiveMinorVersion();
    }

    public boolean setInitParameter(String name, String value) {
        return this.getServletContext().setInitParameter(name, value);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return this.getServletContext().addServlet(servletName, className);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return this.getServletContext().addServlet(servletName, servlet);
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return this.getServletContext().addServlet(servletName, servletClass);
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        return (T)this.getServletContext().createServlet(clazz);
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return this.getServletContext().getServletRegistration(servletName);
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return this.getServletContext().getServletRegistrations();
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return this.getServletContext().addFilter(filterName, className);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return this.getServletContext().addFilter(filterName, filter);
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return this.getServletContext().addFilter(filterName, filterClass);
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        return (T)this.getServletContext().createFilter(clazz);
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return this.getServletContext().getFilterRegistration(filterName);
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return this.getServletContext().getFilterRegistrations();
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.getServletContext().getSessionCookieConfig();
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.getServletContext().setSessionTrackingModes(sessionTrackingModes);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.getServletContext().getDefaultSessionTrackingModes();
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return this.getServletContext().getEffectiveSessionTrackingModes();
    }

    public void addListener(String className) {
        this.getServletContext().addListener(className);
    }

    public <T extends EventListener> void addListener(T t) {
        this.getServletContext().addListener(t);
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        this.getServletContext().addListener(listenerClass);
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        return (T)this.getServletContext().createListener(clazz);
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.getServletContext().getJspConfigDescriptor();
    }

    public ClassLoader getClassLoader() {
        return this.getServletContext().getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
        this.getServletContext().declareRoles(roleNames);
    }

    public String getVirtualServerName() {
        return this.getServletContext().getVirtualServerName();
    }

    static class RequestDispatcherWrapper
    implements RequestDispatcher {
        private final RequestDispatcher delegate;

        public RequestDispatcherWrapper(RequestDispatcher rd) {
            this.delegate = rd;
        }

        public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            this.delegate.forward(RequestDispatcherWrapper.unwrapServletRequest(request), RequestDispatcherWrapper.unwrapServletResponse(response));
        }

        public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            this.delegate.include(RequestDispatcherWrapper.unwrapServletRequest(request), RequestDispatcherWrapper.unwrapServletResponse(response));
        }

        RequestDispatcher getDelegate() {
            return this.delegate;
        }

        static ServletRequest unwrapServletRequest(ServletRequest request) {
            ServletRequest lastRequest = request;
            while (request != null) {
                if (request instanceof SlingHttpServletRequestImpl) {
                    return ((SlingHttpServletRequestImpl)request).getRequest();
                }
                if (request instanceof ServletRequestWrapper) {
                    lastRequest = request;
                    request = ((ServletRequestWrapper)request).getRequest();
                    continue;
                }
                return request;
            }
            return lastRequest;
        }

        static ServletResponse unwrapServletResponse(ServletResponse response) {
            ServletResponse lastResponse = response;
            while (response != null) {
                if (response instanceof SlingHttpServletResponseImpl) {
                    return ((SlingHttpServletResponseImpl)response).getResponse();
                }
                if (response instanceof ServletResponseWrapper) {
                    lastResponse = response;
                    response = ((ServletResponseWrapper)response).getResponse();
                    continue;
                }
                return response;
            }
            return lastResponse;
        }
    }
}

